<?php $__env->startSection('content'); ?>
<div class="container mt-5">
    <div class="row">
        <div class="col-md-12">

            <div class="card shadow-sm">
                <div class="card-body">

                    <!-- Search Input -->
                    <div class="mb-3">
                        <input type="text" id="search" class="form-control" placeholder="Search by ID, Name or Phone">
                    </div>

                    <div id="customer-table">
                        <?php echo $__env->make('customer.table', ['customers' => $customers], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>


<!-- jQuery CDN -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {

let timer;
$('#search').on('keyup', function() {
    clearTimeout(timer);
    var query = $(this).val();
    timer = setTimeout(function() {
        $.ajax({
            url: "<?php echo e(route('customers.search')); ?>",
            type: "GET",
            data: { query: query },
            success: function(data) {
                $('#customer-table').html(data);
            }
        });
    }, 300);
});
});
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\public_html\resources\views/customer-view.blade.php ENDPATH**/ ?>