@if($customers->count() > 0)
    <table class="table table-bordered table-striped">
        <thead class="table-light">
            <tr>
                <th>#</th>
                <th>Name</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Location</th>
            </tr>
        </thead>
        <tbody>
            @php
                $num = ($customers->currentPage() - 1) * $customers->perPage() + 1;
            @endphp
            @foreach($customers as $customer)
                <tr>
                    <td>{{ $num }}.</td>
                    <td>{{ $customer->name ?? '-' }}</td>
                    <td>{{ $customer->email ?? '-' }}</td>
                    <td>{{ $customer->phone ?? '-' }}</td>
                    <td>{{ $customer->location ?? '-' }}</td>
                </tr>
            @php $num++; @endphp
            @endforeach
        </tbody>
    </table>

    <div class="d-flex justify-content-center mt-3">
        {{ $customers->links('pagination::bootstrap-4') }}
    </div>
@else
    <p class="text-center">No Customer found!</p>
@endif
