<?php if($customers->count() > 0): ?>
    <table class="table table-bordered table-striped">
        <thead class="table-light">
            <tr>
                <th>#</th>
                <th>Name</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Location</th>
            </tr>
        </thead>
        <tbody>
            <?php
                $num = ($customers->currentPage() - 1) * $customers->perPage() + 1;
            ?>
            <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($num); ?>.</td>
                    <td><?php echo e($customer->name ?? '-'); ?></td>
                    <td><?php echo e($customer->email ?? '-'); ?></td>
                    <td><?php echo e($customer->phone ?? '-'); ?></td>
                    <td><?php echo e($customer->location ?? '-'); ?></td>
                </tr>
            <?php $num++; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <div class="d-flex justify-content-center mt-3">
        <?php echo e($customers->links('pagination::bootstrap-4')); ?>

    </div>
<?php else: ?>
    <p class="text-center">No Customer found!</p>
<?php endif; ?>
<?php /**PATH /home/launsxbm/public_html/resources/views/customer/table.blade.php ENDPATH**/ ?>