<?php $__env->startSection('content'); ?>

    <style>
        body,
        body .card {
            background: #000;
            color: #fff;
        }

        /* Table Styles */
        body .table,
        body #customer-table .table td {
            background: transparent !important;
            color: #fff !important;
        }

        body .table thead th {
            background: #01992a !important;
            color: #fff !important;
        }

        /* Pagination Styles */
        body .pagination li a {
            background: transparent !important;
            color: #fff !important;
            border: 1px solid #cecece6b;
        }

        /* Active Pagination */
        body .pagination .page-item.active a,
        body .pagination .page-link.active,
        body .pagination .active>.page-link {
            background: #01992a !important;
            color: #fff !important;
            border: 1px solid #01992a !important;
        }

        /* Hover Effect */
        body .pagination .page-link:hover,
        body .pagination a[aria-label="Next »"]:hover {
            background: #01992a !important;
            color: #fff !important;
            border: 1px solid #01992a !important;
        }

        /* Disabled Pagination (Fixed selector typo) */
        body .pagination .page-item.disabled .page-link {
            background: transparent !important;
            color: #888 !important;
            border: 1px solid #444 !important;
        }

        /* Search Input */
        body #search {
            background: transparent !important;
            color: #fff !important;
            border: 1px solid #ffffff9e !important;
        }

        body #search::placeholder {
            color: #ffffff9e !important;
        }

        body .pagination a.page-link:focus {
            box-shadow: none !important
        }

        /* Common Box Base */
        .unique-box-1,
        .unique-box-2,
        .unique-box-3 {
            background: #111;
            color: #fff;
            border-radius: 16px;
            padding: 25px;
            width: 320px;
            box-shadow: 0 0 15px rgba(255, 255, 255, 0.05);
            border: 1px solid transparent;
            text-align: center;
            transition: all 0.4s ease;
            cursor: pointer;
        }

        /* Box Text */
        .unique-box-1 h3,
        .unique-box-2 h3,
        .unique-box-3 h3 {
            font-size: 1.4rem;
            margin-bottom: 10px;
            font-weight: 600;
        }

        .unique-box-1 p,
        .unique-box-2 p,
        .unique-box-3 p {
            font-size: 0.95rem;
            color: #fbfbfb;
            line-height: 1.6;
            margin-bottom: 0;
        }

        /* Unique Box Styles */
        .unique-box-1 {
            border-color: #01992a;
            background: linear-gradient(145deg, #0b0b0b, #141414);
        }

        .unique-box-1:hover {
            transform: translateY(-8px);
            box-shadow: 0 0 25px rgba(1, 153, 42, 0.5);
            border-color: #01992a;
        }

        /* Blue Box */
        .unique-box-2 {
            border-color: #0077ff;
            background: linear-gradient(145deg, #0a0a0a, #151515);
        }

        .unique-box-2:hover {
            transform: translateY(-8px);
            box-shadow: 0 0 25px rgba(0, 119, 255, 0.5);
            border-color: #0077ff;
        }

        /* Orange Box */
        .unique-box-3 {
            border-color: #ff6600;
            background: linear-gradient(145deg, #0b0b0b, #161616);
        }

        .unique-box-3:hover {
            transform: translateY(-8px);
            box-shadow: 0 0 25px rgba(255, 102, 0, 0.5);
            border-color: #ff6600;
        }

        .unique-box-container {
            display: flex;
            justify-content: center;
            gap: 20px;
            padding-bottom: 25px;
            padding-top: 25px;
            flex-wrap: wrap;
        }


        @media (max-width: 767px) {

            body #customer-table {
                overflow-x: hidden !important;
            }

            #customer-table .table th,
            #customer-table .table td {
                font-size: 14px;
                padding: 8px 10px;
            }

            /* Ensure the wrapper is visible and scrollable on mobile */
            #customer-table .table {
                display: block;
                -webkit-overflow-scrolling: touch;
                overflow-x: auto;
                width: 100%;
            }

            /* Make pagination wrap nicely on small screens */
            #customer-table .pagination {
                display: flex;
                flex-wrap: wrap;
                justify-content: center;
                gap: 6px;
            }

            /* Make search full width on mobile if present */
            #search {
                width: 100%;
                margin-bottom: 10px;
                box-sizing: border-box;
            }

            .unique-box-1,
            .unique-box-2,
            .unique-box-3 {
                width: 100%;
                margin-bottom: 20px;
            }

            .unique-box-container {
                flex-direction: column;
            }
        }
    </style>


    <div class="container mt-5">
        <div class="row">
            <div class="col-md-12">

                <div class="logo-main d-flex justify-content-center">
                    <img src="https://launch-pad.pw/public/assets/uploads/restaurant_img/1760153655_logo-square-new.png"
                        alt="Restaurant Image" style="max-width: 120px; height: auto;">

                </div>
                <div class="unique-box-container">
                    <?php if($locations): ?>
                        <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="unique-box-container">
                                <div class="unique-box-1">
                                    <h3><?php echo e($loc->location); ?></h3>
                                    <p><?php echo e($loc->total); ?></p>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </div>


                

                <div class="card shadow-sm">
                    <div class="card-body">
                        <!-- Search Input -->
                        <div class="mb-3">
                            <input type="text" id="search" class="form-control"
                                placeholder="Search by ID, Name or Phone">
                        </div>

                        <div id="customer-table">
                            <?php echo $__env->make('customer.table', ['customers' => $customers], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>


    <!-- jQuery CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {

            let timer;
            $('#search').on('keyup', function() {
                clearTimeout(timer);
                var query = $(this).val();
                timer = setTimeout(function() {
                    $.ajax({
                        url: "<?php echo e(route('customers.search')); ?>",
                        type: "GET",
                        data: {
                            query: query
                        },
                        success: function(data) {
                            $('#customer-table').html(data);
                        }
                    });
                }, 300);
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\public_html\resources\views/customer/customer-view.blade.php ENDPATH**/ ?>