<?php

namespace App\Models;

use App\Models\Customer;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Restaurant extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'address',
        'website',
        'image',
    ];

    // Restaurant belongs to User
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // Restaurant belongs to customer
    public function customer()
    {
        return $this->hasMany(Customer::class);
    }
}
