<?php

namespace App\Models;

use App\Models\Restaurant;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class GenerateUrl extends Model
{
    use HasFactory;

    protected $fillable=[
        'restaurant_id',
        'token',
        'url',
    ];

    /**
     * Get the restaurant that owns the GenerateUrl
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function restaurant(): BelongsTo
    {
        return $this->belongsTo(Restaurant::class);
    }
}
