<!DOCTYPE html>
<html lang="en">

<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0" />
<title>Thank You Gesture</title>
<style>
  body {
    margin: 0;
    padding: 0;
    background: linear-gradient(180deg, #f5f7fb, #eef2ff);
    font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;
    display: flex;
    justify-content: center;
    align-items: center;
    min-height: 100vh;
  }

  .thankyou-card {
    background: #fff;
    border-radius: 14px;
    box-shadow: 0 8px 30px rgba(20, 30, 60, 0.08);
    padding: 30px;
    max-width: 500px;
    width: 90%;
    text-align: center;
    position: relative;
    overflow: hidden;
  }

  .gesture {
    font-size: 60px;
    margin-bottom: 15px;
    display: inline-block;
    animation: float 3s ease-in-out infinite;
  }

  @keyframes float {
    0% { transform: translateY(0) scale(1); }
    50% { transform: translateY(-10px) scale(1.05); }
    100% { transform: translateY(0) scale(1); }
  }

  h1 {
    margin: 10px 0;
    font-size: 28px;
    color: #1e293b;
  }

  p {
    color: #6b7280;
    line-height: 1.6;
    font-size: 16px;
    margin-bottom: 20px;
  }

  button {
    background: #2b7cff;
    color: #fff;
    padding: 12px 20px;
    border: none;
    border-radius: 8px;
    font-size: 16px;
    cursor: pointer;
    box-shadow: 0 5px 15px rgba(43, 124, 255, 0.3);
    transition: 0.3s;
  }

  button:hover {
    background: #1e5fcc;
  }

  .confetti span {
    position: absolute;
    width: 8px;
    height: 12px;
    border-radius: 2px;
    background: #ffb703;
    top: -10px;
    opacity: 0.9;
    animation: fall 2s linear infinite;
  }

  @keyframes fall {
    0% { transform: translateY(-10px) rotate(0deg); opacity: 1; }
    100% { transform: translateY(500px) rotate(720deg); opacity: 0; }
  }

  .confetti span:nth-child(2n) { background: #ff6b6b; }
  .confetti span:nth-child(3n) { background: #6ee7b7; }
  .confetti span:nth-child(4n) { background: #9b5cff; }
  .confetti span:nth-child(5n) { background: #60a5fa; }
</style>
</head>
<body>

  <div class="thankyou-card">
    <div class="gesture">🙏</div>
    <h1>Thank You!</h1>
    <p>Thank You for sharing your information.</p>

  </div>



</body>

</html>
<?php /**PATH C:\wamp64\www\LaunchQR\resources\views/thank-you.blade.php ENDPATH**/ ?>