<?php

namespace App\Http\Controllers;

use App\Models\Customer;
use App\Models\GenerateUrl;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

class URLController extends Controller
{

    public function create($restaurant_id, $token)
    {
        $checkToken= GenerateUrl::with('restaurant')->where('token', $token)->first();
        if($checkToken){
            $imagePath= $checkToken->restaurant->image;
            $checkCustomer= Customer::where('token', $token)->first();
            if($checkCustomer){
                // return 'You Are Already Submitted This Form';
                // return 'You Are Already Submitted This Form';
                 return view('submit-message', compact('restaurant_id', 'token', 'imagePath'));
            }
            return view('customer.customer-form', compact('restaurant_id', 'token', 'imagePath'));
        } else {
            return 'Invalid URL';
        }
    }

    public function store(Request $request)
    {
        $request->validate([
            'restaurant_id' => 'required'
        ]);

        // Generate a unique token (retry until it's unique)
        do {
            $token = Str::random(10);
        } while (GenerateUrl::where('token', $token)->exists());

        // Make the unique URL
        $url = url('/customer/' . $request->restaurant_id . '/' . $token);

        // Save data to DB
        $data = GenerateUrl::create([
            'restaurant_id' => $request->restaurant_id,
            'url'           => $url,
            'token'         => $token,
        ]);

        return response()->json([
            'data' => $url
        ], 200);
    }
}
