<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\DashboardController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return redirect()->route('login');
});



Auth::routes();

// Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

Route::middleware('auth')->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index']);
    Route::post('/status-change/{status}/{restaurant_id}', [DashboardController::class, 'changeStatus']);
    Route::post('/create-restaurant', [AuthController::class, 'store']);
    Route::get('/get-restaurant-detail/{restaurant_id}', [AuthController::class, 'getRestaurantDetail']);
    Route::post('/update-restaurant/{restaurant_id}', [AuthController::class, 'updateRestaurant']);
    Route::get('/get-filter-data', [DashboardController::class, 'getFilterData']);
});

