
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Radio App Portal</title>
  <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<style>
    #editRestaurantModal input[type="text"],
    #editRestaurantModal input[type="number"] {
        color: black;           /* Text color */
        background-color: #fff; /* Background white */
    }

    .custom-alert {
        padding: 12px 20px;
        margin: 10px 0;
        border-radius: 6px;
        font-weight: 500;
        position: relative;
        animation: fadeIn 0.3s ease-in-out;
        font-size: 16px;
        line-height:23px;
    }

    .custom-alert.success {
        background: #d4edda;
        color: #155724;
        border: 1px solid #c3e6cb;
        font-size: 16px;
        line-height:23px;
    }

    .custom-alert.error {
        background: #f8d7da;
        color: #721c24;
        border: 1px solid #f5c6cb;
        font-size: 16px;
        line-height:23px;
    }

    .custom-alert.warning {
        background: #fff3cd;
        color: #856404;
        border: 1px solid #ffeeba;
        font-size: 16px;
        line-height:23px;
    }

  .custom-alert .close-btn {
    position: absolute;
    top: 5px;
    right: 10px;
    cursor: pointer;
    font-weight: bold;
    max-width: 18px;
    font-size: 28px;
    height: 16px;
    line-height: 16px;

    }
    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(-10px); }
        to { opacity: 1; transform: translateY(0); }
    }
</style>

</head>
<body>

<div class="container">
<div class="header">
   <img src="<?php echo e(asset('assets/images/logo.png')); ?>" alt="" class="logo">
       <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                onclick="event.preventDefault();
                                document.getElementById('logout-form').submit();">
                <?php echo e(__('Logout')); ?>

            </a>

            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                <?php echo csrf_field(); ?>
            </form>
</div>
<div id="msg"></div>
<div class="form-header">
  <!-- Add Form -->
    <input type="text" id="search" placeholder="Search Here">
        <form id="restaurantForm">
            <input type="text" name="name" placeholder="Restaurant Name" required>
            <input type="file" name="image" required> <input type="number" name="r_number" placeholder="Restaurant Number" required>

            <!-- 🎨 Color input -->
            <label for="color" style="display:block; margin-top:10px; font-weight:bold;color:#ffffff">
                Select Color:
            </label>
            <input type="color" name="color_code" id="color" required style=" width: 100%; height: 50px; border: none; cursor: pointer; padding: 0; background: none; " >
            <button type="submit">➕ Add Restaurant</button>
        </form>

            <!--<a class="dropdown-item" href="<?php echo e(route('logout')); ?>"-->
            <!--    onclick="event.preventDefault();-->
            <!--                    document.getElementById('logout-form').submit();">-->
            <!--    <?php echo e(__('Logout')); ?>-->
            <!--</a>-->

            <!--<form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">-->
            <!--    <?php echo csrf_field(); ?>-->
            <!--</form>-->

</div>
  <!-- Table -->
  <div class="table-wrapper">
    <table>
      <thead>
        <tr>
          <th>#</th>
          <th>Restaurant Name</th>
          <th>Counter ID:</th>
          <th>Status</th>
          <th>Edit</th>
        </tr>
      </thead>
      <tbody id="restaurantTbody">
        <?php $number=0; ?>
        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($number); ?></td>
                <td><?php echo e($user->restaurant->name ?? ''); ?></td>
                <td><?php echo e($user->restaurant->r_number ?? ''); ?></td>
                <td>
                    <label class="switch">
                        <input type="checkbox" class="restaurant_status" data-id="<?php echo e($user->restaurant->id ?? ''); ?>"
                            <?php echo e($user->restaurant->status=='1' ? 'checked' : ''); ?>

                            >
                        <span class="slider"></span>
                    </label>
                </td>
                <td>
                    <?php $restaurant= $user->restaurant->id ?? ''; ?>
                    <button
                        type="button"
                        class="btn btn-primary editRestaurantBtn"
                        data-id="<?php echo e($restaurant); ?>"
                        data-bs-toggle="modal"
                        data-bs-target="#editRestaurantModal">
                        Edit
                    </button>
                </td>
            </tr>
            <?php $number++; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </tbody>
    </table>

   <!-- Pagination Controls -->
    <div class="pagination">
    <button onclick="prevPage()">Prev</button>
    <span id="paginationNumbers"></span>
    <button onclick="nextPage()">Next</button>
    </div>

  </div>
  </div>
</div>




<!-- Edit Restaurant Modal -->
<div class="modal fade" id="editRestaurantModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered"> <!-- ✅ center modal vertically -->
        <div class="modal-content">
            <form id="editRestaurantForm" enctype="multipart/form-data">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Restaurant</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <div class="modal-body">
                    <input type="hidden" name="id" id="edit_id">

                    <div class="mb-3">
                        <label>Restaurant Name:</label>
                        <input type="text" name="name" id="edit_name" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label>Restaurant Number:</label>
                        <input type="number" name="r_number" id="edit_r_number" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label>Restaurant Color:</label>
                        <input type="color" name="color_code" id="edit_color_code" class="form-control form-control-color" style="width: 100%; height: 50px;" required>
                    </div>

                    <div class="mb-3">
                        <label>Current Image:</label>
                        <img id="current_image" src="" alt="Restaurant Image" style="width:100px; display:block; margin-top:5px;">
                    </div>

                    <div class="mb-3">
                        <label>Change Image (optional):</label>
                        <input type="file" name="image" id="edit_image" class="form-control">
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Update Restaurant</button>
                </div>
            </form>
        </div>
    </div>
</div>





<script src="<?php echo e(asset('assets/js/script.js')); ?>"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
    $(document).ready(function(){

    $('#restaurantForm').submit(function(e){
        e.preventDefault();
        // var formData = $(this).serialize();
        var formData = new FormData(this);

        $.ajax({
            url: "<?php echo e(url('/create-restaurant')); ?>",
            method: "POST",
            processData: false, // ✅ Important for file upload
            contentType: false, // ✅ Important for file upload
            data: formData,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if (response.success) {
                    // ✅ Success Message
                    $("#msg").append(`
                        <div class="custom-alert success">
                           ✅ Restaurant added Successfully
                            <span class="close-btn" onclick="this.parentElement.remove();">×</span>
                        </div>
                    `);

                    // ✅ Append new row in table
                    let restaurant = response.data;
                    let rowCount = $("#restaurantTbody tr").length + 1;

                    $("#restaurantTbody").append(`
                        <tr>
                            <td>${rowCount}</td>
                            <td>${restaurant.name}</td>
                            <td>${restaurant.r_number}</td>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" class="restaurant_status" data-id="${restaurant.id}" ${restaurant.status == '1' ? 'checked' : ''}>
                                    <span class="slider"></span>
                                </label>
                            </td>
                            <td>
                                <button
                                    type="button"
                                    class="btn btn-primary editRestaurantBtn"
                                    data-id="${restaurant.id}"
                                    data-bs-toggle="modal"
                                    data-bs-target="#editRestaurantModal">
                                    Edit
                                </button>
                            </td>
                        </tr>
                    `);

                    // ✅ Reset form
                    $('#restaurantForm')[0].reset();
                }
            },
            error: function(xhr) {
                console.error("Error:", xhr.responseText);
                $("#msg").append(`
                    <div class="custom-alert warning">
                        ❌ Failed to add Restaurant
                        <span class="close-btn" onclick="this.parentElement.remove();">×</span>
                    </div>
                `);
            }
        });
    });


    $('.restaurant_status').change(function() {
        let status = $(this).is(":checked") ? '1' : '0';
        let restaurantId = $(this).data('id');
        $.ajax({
                url: "<?php echo e(url('/status-change')); ?>/" + status + "/" + restaurantId,
            type: "post",
            data: {
                _token : '<?php echo e(csrf_token()); ?>',
                status : status,
                restaurantId : restaurantId,
            },
            success:function(response){
                $("#msg").html(""); // purane alerts clear

                if(response){
                    if(response.enable){
                        $("#msg").append(`
                            <div class="custom-alert success">
                                ✅ Restaurant Enabled Successfully
                                <span class="close-btn" onclick="this.parentElement.remove();">×</span>
                            </div>
                        `);
                    } else {
                        $("#msg").append(`
                            <div class="custom-alert warning">
                                ⚠️ Restaurant Disabled Successfully
                                <span class="close-btn" onclick="this.parentElement.remove();">×</span>
                            </div>
                        `);
                    }
                } else {
                    $("#msg").append(`
                        <div class="custom-alert error">
                            ❌ Failed to Change Status
                            <span class="close-btn" onclick="this.parentElement.remove();">×</span>
                        </div>
                    `);
                }
            }
        });
    });

    $('#search').on('keyup', function(){
        var search = $(this).val();

            $.ajax({
            url: "<?php echo e(url('get-filter-data')); ?>",
            data: { search: search },
            success:function(response){
                if(response.data){
                    var tbody = '';
                    var number = 0;
                    $.each(response.data, function(index, user){
                        tbody += `<tr>
                        <td>${number}</td>
                        <td>${user.name}</td>
                        <td>${user.r_number}</td>
                        <td>
                            <label class="switch">
                                <input type="checkbox" class="restaurant_status" data-id="${user.id}" ${(user.status == '1' ? ' checked' : '')}>
                                <span class="slider"></span>
                            </label>
                        </td>
                        <td>
                            <button
                                type="button"
                                class="btn btn-primary editRestaurantBtn"
                                data-id="${restaurant.id}"
                                data-bs-toggle="modal"
                                data-bs-target="#editRestaurantModal">
                                Edit
                            </button>
                        </td>
                        </tr>`;
                        number++;
                    });
                    $('#restaurantTbody').html(tbody);
                } else {
                    $('#restaurantTbody').html('<tr><td colspan="4">No data found</td></tr>');
                }
            }
        });




    });

    $(document).on('click', '.editRestaurantBtn', function() {
        let restaurantId = $(this).data('id');

        $.ajax({
            url: `/get-restaurant-detail/${restaurantId}`,
            method: "GET",
            success: function(response) {
                if (response.restaurant) {
                    let r = response.restaurant;

                    // Populate fields
                    $('#edit_id').val(r.id);
                    $('#edit_name').val(r.name);
                    $('#edit_r_number').val(r.r_number);
                    $('#edit_color_code').val(r.color_code);

                    // Show current image
                    $('#current_image').attr('src', '/uploads/restaurants/' + r.image); // adjust path

                    // Show modal
                    let modal = new bootstrap.Modal(document.getElementById('editRestaurantModal'));
                    modal.show();
                } else {
                    alert('Restaurant not found');
                }
            },
            error: function(xhr) {
                console.error("Error fetching restaurant:", xhr.responseText);
            }
        });
    });


    $('#editRestaurantForm').submit(function(e){
        e.preventDefault();

        var formData = new FormData(this);

        $.ajax({
            url: `/update-restaurant/${$('#edit_id').val()}`,
            method: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if(response.success){
                    // ✅ Update message
                    $("#msg").append(`
                        <div class="custom-alert success">
                            ✅ Restaurant updated successfully
                            <span class="close-btn" onclick="this.parentElement.remove();">×</span>
                        </div>
                    `);

                    // ✅ Update row in table
                    let r = response.data;
                    let row = $(`#restaurantTbody tr`).filter(function(){
                        return $(this).find('.editRestaurantBtn').data('id') == r.id;
                    });

                    row.find('td:eq(1)').text(r.name);
                    row.find('td:eq(2)').text(r.r_number);
                    row.find('.restaurant_status').prop('checked', r.status == '1');

                    // Close modal
                    let modalEl = document.getElementById('editRestaurantModal');
                    let modal = bootstrap.Modal.getInstance(modalEl);
                    modal.hide();
                }
            },
            error: function(xhr){
                console.error("Update error:", xhr.responseText);
            }
        });
    });



    });

</script>
</body>
</html>
<?php /**PATH C:\Users\Meezotech\Downloads\radio\lunchPad\resources\views/dashboard.blade.php ENDPATH**/ ?>